/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.fluid;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import me.jellysquid.mods.sodium.mixin.features.chunk_rendering.AccessorBlockFluidRenderer;
import me.jellysquid.mods.sodium.mixin.features.chunk_rendering.AccessorBlockRenderDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EmbeddiumFluidSpriteCache {
    private final TextureAtlasSprite[] sprites = new TextureAtlasSprite[3];
    private final Object2ObjectOpenHashMap<ResourceLocation, TextureAtlasSprite> spriteCache = new Object2ObjectOpenHashMap();
    private final TextureAtlasSprite[] waterOverride;
    private final TextureAtlasSprite[] lavaOverride;

    public EmbeddiumFluidSpriteCache() {
        AccessorBlockFluidRenderer fluidRenderer = (AccessorBlockFluidRenderer)((AccessorBlockRenderDispatcher)Minecraft.func_71410_x().func_175602_ab()).getFluidRenderer();
        this.waterOverride = new TextureAtlasSprite[3];
        TextureAtlasSprite[] water = fluidRenderer.getAtlasSpritesWater();
        this.waterOverride[0] = water[0];
        this.waterOverride[1] = water[1];
        this.waterOverride[2] = fluidRenderer.getAtlasSpriteWaterOverlay();
        this.lavaOverride = new TextureAtlasSprite[3];
        TextureAtlasSprite[] lava = fluidRenderer.getAtlasSpritesLava();
        this.lavaOverride[0] = lava[0];
        this.lavaOverride[1] = lava[1];
    }

    private TextureAtlasSprite getTexture(ResourceLocation identifier) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.spriteCache.get((Object)identifier);
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(identifier.toString());
            this.spriteCache.put((Object)identifier, (Object)sprite);
        }
        return sprite;
    }

    public TextureAtlasSprite[] getSprites(Fluid fluid) {
        if (fluid == FluidRegistry.WATER) {
            return this.waterOverride;
        }
        if (fluid == FluidRegistry.LAVA) {
            return this.lavaOverride;
        }
        this.sprites[0] = this.getTexture(fluid.getStill());
        this.sprites[1] = this.getTexture(fluid.getFlowing());
        ResourceLocation overlay = fluid.getOverlay();
        this.sprites[2] = overlay != null ? this.getTexture(overlay) : null;
        return this.sprites;
    }
}

